/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

final class OptionValidator {
    OptionValidator() {
    }

    static void validateOption(String string) throws IllegalArgumentException {
        if (string == null) {
            return;
        }
        if (string.length() == 1) {
            char c = string.charAt(0);
            if (!OptionValidator.isValidOpt(c)) {
                throw new IllegalArgumentException("Illegal option name '" + c + "'");
            }
        } else {
            for (char c : string.toCharArray()) {
                if (OptionValidator.isValidChar(c)) continue;
                throw new IllegalArgumentException("The option '" + string + "' contains an illegal character : '" + c + "'");
            }
        }
    }

    private static boolean isValidOpt(char c) {
        return OptionValidator.isValidChar(c) || c == '?' || c == '@';
    }

    private static boolean isValidChar(char c) {
        return Character.isJavaIdentifierPart(c);
    }
}

