Tomcat setup
------------

On CentOS 6/7:

Tomcat 7:

Follow the guide at https://www.digitalocean.com/community/tutorials/how-to-install-apache-tomcat-7-on-centos-7-via-yum

Then,

open /usr/libexec/tomcat/server, and add the following lines:

```
#!/bin/bash

CATALINA_OPTS="$CATALINA_OPTS -Dcom.sun.management.jmxremote=true \
                  -Dcom.sun.management.jmxremote.port=9090 \
                  -Dcom.sun.management.jmxremote.ssl=false \
                  -Dcom.sun.management.jmxremote.authenticate=false \
                  -Djava.rmi.server.hostname=$(/usr/bin/hostname -I) \
                  -Dcom.sun.management.jmxremote.rmi.port=9704"
```

if we run ```service tomcat restart```, we should be able to see an open port 9090:

```
yum install nmap -y
nmap 127.0.0.1 -p9000-9100
```

If "zeus-admin" is running, then JMX monitoring is operational.
To access it from a remote machine, install the Java SDK (at least version 1.8).
Continue to "Remote Machine".



Tomcat 8+:

Follow the guide for Tomcat 8 at https://www.digitalocean.com/community/tutorials/how-to-install-apache-tomcat-8-on-centos-7

To use the plugin you have to enable JMX. If you followed the digitalocean guides, then you only need to do the following:

In your Catalina home directory (/opt/tomcat by default), navigate to your ```bin``` directory, and edit the file called setenv.sh.
You can create the file if it doesn't exist.
You'll want to edit the script to look similar to the one below.

    #!/bin/bash
    JRE_HOME=/usr/lib/jvm/java-1.8.0-openjdk-1.8.0.151-1.b12.el7_4.x86_64/jre

    CATALINA_OPTS="$CATALINA_OPTS -Dcom.sun.management.jmxremote=true \
                      -Dcom.sun.management.jmxremote.port=9090 \
                      -Dcom.sun.management.jmxremote.ssl=false \
                      -Dcom.sun.management.jmxremote.authenticate=false \
                      -Djava.rmi.server.hostname=$(/usr/bin/hostname -I) \
                      -Dcom.sun.management.jmxremote.rmi.port=9704"


Note that JRE_HOME points to a version-specific directory. If you don't have the exact same openJDK package, you'll need to find the equivalent and use that.

The port numbers shown (9090 and 9704) can be changed at will; nothing other than our monitoring solution will touch them.

Once you've finished that, restart the tomcat service.

```service tomcat restart```

Remote Machine:

Install GNOME Desktop and OpenJDK 1.8:

```yum groupinstall "GNOME Desktop" -y```

```yum install java-1.8.0-openjdk java-1.8.0-openjdk-devel"

When both are installed, use ```startx``` to start the GUI, then ```jconsole``` to run the GUI app.
From the GUI, select "Remote Process", and enter the service URL.


Testing
-------

First, to make sure you have your Tomcat installation set up correctly, try using ```jconsole``` to access the metrics.
```jconsole``` monitors Tomcat through the same protocol as our plugin, so if jconsole doesn't work, there's more setup to be done on the Tomcat side of things.

Your service URL is probably service:jmx:rmi:///jndi/rmi://xxx.xxx.xxx.xxx:yyyy/jmxrmi, where xxx.xxx.xxx.xxx is your machine's IP address and yyyy is -Dcom.sun.management.jmxremote.port as set above.

Then, we can use the plugin. The plugin works remotely from tomcat, but requires java to be installed in order for it to be run.

usage: java -jar check_tomcat.jar [OPTIONS]

The plugin requires the following parameters:

--warning (-w): Warning threshold. Uses the same syntax as usual.
--critical (-c): Critical threshold. 
--service-url (-s): The JMX service URL. This is the same one that you need to use for jconsole.

Optionally, we have the remaining parameters:

--timeout (-t): plugin timeout in seconds. Setting this to 0 allows the plugin to run indefinitely.
--check-types (-C): the actual checks to run. See the end of this document.
--username (-u): The username for the Tomcat JMX manager. Only required if you set Dcom.sun.management.jmxremote.authenticate to true.
--password (-p): The password for the user mentioned above.

Check Types
------------

Most check types work in a straightforward manner. For example, the following plugin call gives the number of running threads on your Tomcat instance, returning warning if over 10 threads and critical if over 25:

java -jar check_tomcat.jar -C ThreadCount -s <service_url> -w 10 -c 25

ClassCount - a count of the number of classes running in this Tomcat instance
ThreadCount - a count of the number of classes running in this Tomcat instance
Uptime - measures how long the server has been alive in milliseconds

For the memory-related group, we do the same thing, but with parameters in bytes. This call gives the total heap memory usage on the Tomcat instance, returning warning if over 128 MiB and critical if over 256 MiB:

MemorySimpleHeap
java -jar check_tomcat.jar -C MemorySimpleHeap -s <service_url> -w 134217728 -c 268435456

The service output will be in the largest reasonable unit (up to GiB).

MemorySimpleHeap - measures the total heap-allocated memory usage (Eden Space + Survivor Space + Old Gen)
MemoryPSEden - measures the heap-allocated objects which haven't seen a garbage collection cycle.
MemoryPSSurvivor - measures the heap-allocated objects which have seen GC and survived.
MemoryPSOld - measures the heap-allocated objects which have survived several GC's

MemorySimpleNonHeap - measures the total non-heap-allocated memory usage (Code Cache + Compressed Class Space + Metaspace)
MemoryCodeCache - measures the memory used by the code cache
MemoryCompressedClass - measures the memory used by compressed class space
MemoryMetaspace - measures the memory used by metaspace


We can also track global request processors. We can either do this in terms of the total number of requests, or in terms of bandwidth usage.
Either way, we need the MBean name of the processor we're trying to monitor. The easiest way to find this out is via jconsole (MBeans -> Catalina -> GlobalRequestProcessor).

The following call gives the number of requests per minute since the plugin was last run, alerting on 250/500 requests per minute.

java -jar check_tomcat.jar -C RequestsPerMinute:http-nio-0.0.0.0-8080 -s <service_url> -w 250 -c 500

RequestsPerMinute - returns the requests per minute, over the period since the plugin was last run.
BytesPerMinute - returns the bytes per minute, over the period since the plugin was last run.
BytesPerRequest - combines the two above into a rate.
ErrorsPerMinute - returns the number of 4xx/5xx errors returned by the webserver each minute, over the period since the plugin was last run. 
ProcessingTimePerRequest - returns the average time per request (in milliseconds) since the plugin was last run. 

Finally, checks can be combined so that we're not spooling up a new JVM for each check:

java -jar check_tomcat.jar -C ThreadCount,MemorySimpleHeap,RequestsPerMinute:http-nio-0.0.0.0-8080 -s <service_url> -w 10,134217728,250 -c 25,268435456,500

The multi-check will return the worst alert level among all of its checks.