    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
            <div class="col-sm-6 border-block mb-4">
                <h2 class="mb-2"><?= _('Plugin and Agent Setup') ?></h2>
                <p><?= _('If you use a direct JMX connection between Nagios XI and your application server, you will only need to ensure that your server is remote-JMX-capable. Otherwise, you will need to install NCPA and the Application Server Plugin on your application server.') ?></p>
                <ul class="list-group list-group-numbered">
                    <li class="list-group-item"><a href="<?= $NCPA_download_url ?>" target="_blank"><?= _('Download and install the latest version of NCPA') ?></a></li>
                    <li class="list-group-item"><a href="<?= $java_as_plugin_url ?>" target="_blank"><?= _('Install the Java Application Server Plugin') ?></a></li>
                </ul>
                <p><?= _('Additional documentation for ') ?><a href="<?= $NCPA_docs_url ?>" target="_blank"><?= _('NCPA') ?></a> <?= _(' and for ') ?><a href="<?= $java_as_docs_url ?>" target="_blank"><?= _('monitoring application servers') ?></a></p>
            </div>

            <h2 class="mb-2"><?= $noun_long._(' Information') ?></h2>
            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="address" class="form-label form-item-required"><?= _('IP Address') ?> </label>
                    <div class="input-group position-relative">
                        <input type="text" name="address" id="address" value="<?= encode_form_val($address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter IP Address") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the IP Address
                        </div>
                        <i id="address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="remote" class="form-label form-item-required"><?= sprintf(_('Access %s via'), $noun_long) ?> </label>
                    <div class="input-group position-relative">
                        <select name="remote" id="remote" class="form-select monitor rounded" placeholder="<?= _("Select <?= sprintf(_('Access %s via'), $noun_long) ?>") ?> " required>
                            <option value="JMX" <?= is_selected($remote, "JMX") ?>><?= _('JMX') ?></option>
                            <option value="NCPA" <?= is_selected($remote, "NCPA") ?>><?= _('Remote Agent (NCPA)') ?></option>
                        </select>
                        <div class="invalid-feedback">
                            Please select <?= sprintf(_('Access %s via'), $noun_long) ?>
                        </div>
                        <i id="remote_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>
<?php
    if (java_as_java_not_installed()) {
?>
            <div class="alert alert-danger w-50 jmx-only">
                <div class="align-items-center d-flex pb-3">
                    <i class="material-symbols-outlined md-400">warning</i>
                    <span class="fw-bold pe-2"><?= _('Warning') ?>: </span><?= _('Java Missing') ?>
                </div>
                <div class="card card-p">
                    <p class="text-start"><?= _('To access the JMX ports directly from this server, please install Java') ?></p>
                    <?=_('You will also need to edit the Configuration Manager command definition for check_xi_java_as to include the absolute path of the java binary') ?>
                </div>
            </div>
<?php
    }
?>
            <div class="row mb-2 ncpa-only visually-hidden">
                <div class="col-sm-6">
                    <label for="port" class="form-label form-item-required"><?= _("NCPA Listener Port") ?> </label>
                    <div class="input-group position-relative">
                        <input type="text" name="port" id="port" value="<?= encode_form_val($port) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter NCPA Listener Port") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the NCPA Listener Port
                        </div>
                        <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2 ncpa-only visually-hidden">
                <div class="col-sm-6">
                    <label for="token" class="form-label form-item-required"><?= _("NCPA Token") ?> </label>
                    <div class="input-group position-relative">
                        <input type="password" name="token" id="token" value="<?= encode_form_val($token) ?>" class="form-control monitor rounded-start" placeholder="<?= _("Enter NCPA Token") ?>" required>
                        <button type="button" class="btn btn-outline-secondary btn-show-secret rounded-end tt-bind" id="password-secret" title="<?= _("Show") ?>">
                            <span class="material-symbols-outlined md-22 md-pointer">Visibility</span>
                            <i id="password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </button>
                        <div class="invalid-feedback">
                            Please enter the NCPA Token
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="service_url" class="form-label form-item-required"><?= _('Service URL') ?> <?= xi6_info_tooltip(_('The full JMX service URL').' Ex: '.$sample_service_url) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="service_url" id="service_url" value="<?= encode_form_val($service_url) ?>" class="form-control monitor rounded" placeholder="<?= $sample_service_url ?>" required>
                        <div class="invalid-feedback">
                            Please enter the Service URL
                        </div>
                        <i id="service_url_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="username" class="form-label form-item-required"><?= sprintf(_('%s Username'), $noun_short) ?> <?= xi6_info_tooltip(sprintf(_('The %s user with JMX privileges'), $noun_short)) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="username" id="username" value="<?= encode_form_val($username) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter ").sprintf(_('%s Username'), $noun_short) ?>" required>
                        <div class="invalid-feedback">
                            Please enter the <?= sprintf(_('%s Username'), $noun_short) ?>
                        </div>
                        <i id="username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div id="changePasswordOption" class="row mb-3 mt-4 visually-hidden" hidden>
                <div class="col-sm">
                    <input type="checkbox" id="changePassword" class="form-check-input" name="changePassword">
                    <label for="changePassword" class="form-check-label bold"><?= _("Change <?= sprintf(_('%s Password'), $noun_short) ?>") ?> <?= xi6_info_tooltip(_("Use to change the <?= sprintf(_('%s Password'), $noun_short) ?>, otherwise, the existing <?= sprintf(_('%s Password'), $noun_short) ?> will be preserved.")) ?></label>
                </div>
            </div>

            <div id="setPassword" class="row mb-2">
                <div class="col-sm-6">
                    <label for="password" class="form-label form-item-required"><?= sprintf(_('%s Password'), $noun_short) ?> <?= xi6_info_tooltip(sprintf(_('The password for the %s user above'), $noun_short)) ?></label>
                    <div class="input-group">
                        <input type="password" name="password" id="token" value="<?= encode_form_val($password) ?>" class="usermacro-detection form-control rounded-start" autocomplete="off" placeholder="<?= _("Enter ").sprintf(_('%s Password'), $noun_short) ?>"  required>
                        <button type="button" class="btn btn-outline-secondary btn-show-secret rounded-end tt-bind" id="password-secret" title="<?= _("Show") ?>">
                            <span class="material-symbols-outlined md-22 md-pointer">Visibility</span>
                            <i id="password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </button>
                        <div class="invalid-feedback">
                            Please enter the <?= sprintf(_('%s Password'), $noun_short) ?>.
                        </div>
                    </div>
                </div>
            </div>
        </div> <!-- config -->
    </div> <!-- container -->

    <script>
        $(document).ready(function () {
            $("#remote").change(function () {
                if ($(this).val() === "JMX") {
                    // using JMX directly.
                    $(".jmx-only").removeClass('visually-hidden');
                    $(".ncpa-only").addClass('visually-hidden');
                    $("#port").removeAttr('required');
                    $("#token").removeAttr('required')

                } else {
                    // using NCPA
                    $(".jmx-only").addClass('visually-hidden');
                    $(".ncpa-only").removeClass('visually-hidden');
                    $("#port").attr('required');
                    $("#token").attr('required')
                }
            });

            // Initialize
            if ($("#remote").val() === "JMX") {
                $(".jmx-only").removeClass('visually-hidden');
                $(".ncpa-only").addClass('visually-hidden');
                $("#port").removeAttr('required');
                $("#token").removeAttr('required')

            } else {
                $(".jmx-only").addClass('visually-hidden');
                $(".ncpa-only").removeClass('visually-hidden');
                $("#port").attr('required');
                $("#token").attr('required')
            }
        });
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
