    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
            <h2 class="mb-2"><?= _('Host Information') ?></h2>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="ip_address" class="form-label form-item-required"><?= _('Host Address') ?> <?= xi6_info_tooltip(_('The IP address or FQDN of the host associated with the Log Server query you would like to monitor')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Host Address") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the Host Address
                        </div>
                        <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <h2 class="mt-4"><?= _('Log Server Information') ?></h2>
            <p><?= _('Specify the settings to access your Log Server') ?></p>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="url" class="form-label form-item-required"><?= _('URL') ?> <?= xi6_info_tooltip(_('The URL used to access the Nagios Log Server web interface e.g.(http://logserver.example.com/nagioslogserver/)')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="url" id="url" value="<?= encode_form_val($url) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter URL") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the URL
                        </div>
                        <i id="url_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="url" class="form-label form-item-required"><?= _('API Key') ?> <?= xi6_info_tooltip(_('Authentication token used to access the Log Server API')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="key" id="key" value="<?= encode_form_val($key) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Api Key") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the API Key
                        </div>
                        <i id="url_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <input type="checkbox" name="self_cert" id="self_cert" class="form-check-input mt-1 me-2" <?= is_checked($self_cert, "on") ?>>
                    <label for="self_cert" class="form-label"><?= _('Allow self signed SSL Cert') ?> <?= xi6_info_tooltip(_('Allow the conection to an NLS instance with https if the certificate is self-signed.')) ?></label>
                </div>
            </div>


        </div> <!-- configForm -->
    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
