    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" name="port" value="<?= encode_form_val($port) ?>">
    <input type="hidden" name="username" value="<?= encode_form_val($username) ?>">
    <input type="hidden" name="password" value="<?= encode_form_val($password) ?>">
    <input type="hidden" name="database" value="<?= encode_form_val($database) ?>">
    <input type="hidden" name="sid" value="<?= encode_form_val($sid) ?>">

    <h5 class="ul"><?= _('Oracle Server') ?></h5>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('Address:') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Address:") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the IP Address") ?>
                    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name:') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this Oracle Tablespace')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name:") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Host Name") ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="port" class="form-label"><?= _('Port:') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="port" id="port" value="<?= encode_form_val($port) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Port:") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the Port") ?>
                    </div>
                    <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="sid" class="form-label"><?= _('SID:') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="sid" id="sid" value="<?= encode_form_val($sid) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter SID:") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the SID") ?>
                    </div>
                    <i id="sid_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="username" class="form-label"><?= _('Username:') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="username" id="username" value="<?= encode_form_val($username) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Username:") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the Username") ?>
                    </div>
                    <i id="username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div id="changePasswordOption" class="row mb-3 mt-4 visually-hidden">
            <div class="col-sm">
                <input type="checkbox" id="changePassword" class="form-check-input" name="changePassword">
                <label for="changePassword" class="form-check-label bold"><?= _("Change Password:") ?> <?= xi6_info_tooltip(_("Use to change the Password:, otherwise, the existing Password: will be preserved.")) ?></label>
            </div>
        </div>

        <div id="setPassword" class="row mb-2">
            <div class="col-sm-6">
                <label for="password" class="form-label"><?= _('Password:') ?> </label>
                <div class="input-group input-group-sm">
                    <input type="password" name="password" id="password" value="<?= encode_form_val($password) ?>" class="usermacro-detection form-control form-control-sm rounded-start" autocomplete="off" placeholder="<?= _("Enter Password:") ?>" >
                    <button type="button" class="btn btn-outline-secondary btn-show-secret rounded-end" id="password-secret" title="<?= _("Show Password:") ?>">
                        <span class="material-symbols-outlined md-22 md-pointer">Visibility</span>
                        <i id="password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </button>
                    <div class="invalid-feedback">
                        <?= _("Please enter the Password") ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="database" class="form-label"><?= _('Tablespace:') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="database" id="database" value="<?= encode_form_val($database) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Tablespace:") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the Database") ?>
                    </div>
                    <i id="database_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->

<script type="text/javascript">
    $(document).ready(function() {
        // Set up undo buffers by "category" (thing m_select is managing)
        m_select_cats = ["services"];
        m_select_states = {};

        // Set up handlers and current state for multi-selects
        $.each(m_select_cats, function(i, category) {
            m_select_states[category] = [];

            $("#"+category+"-select").on("change", function($this) {
                manageMultiSelectForTable(category);
            });

            $("#"+category+"-undo").on("click", function($this) {
                multiSelectUndo(category);
            });

            // Set initial state for m selects
            manageMultiSelectForTable(category);
            $("#"+category+"-undo").prop( "disabled", true );
        });

        $(".multiselect").on("mouseenter", function($this) {
            $(this).trigger("focus");
        });

        $(".multi-select-remove").on("click", function($this) {
            // Figure out which was clicked
            fullName = $(this).attr("value");
            elem = "." + fullName;
            category = fullName.split('-')[0];
            name = fullName.replace(category+ '-', '')

            // Update multi select
            optn = $('#' + category + '-select option[value="'+ name +'"]');
            optn.prop('selected', false);
            // console.log("multi-select-remove: ", category, fullName, elem, name, optn)

            // Update table
            manageMultiSelectForTable(category);
        });

        function manageMultiSelectForTable(category) {
            container = "#"+category+"-list";
            select = "#"+category+"-select";
            selVal =  $(select).val();

            // Add new state to undo buffer
            m_select_states[category].push(selVal);
            $("#"+category+"-undo").prop( "disabled", false );
            // console.log("manageMultiSelectForTable: ", category, container, select, selVal)
            // console.log("manageMultiSelectForTable buffer: ", m_select_states[category])

            // Clear multi select and table
            $(container +" .service-item").prop( "checked", false );
            $(container +" .service-item").closest(".row").hide();

            // Apply updated settings
            $.each(selVal, function(i, val) {
                elem = "." + category + "-" + val;
                $(elem).prop( "checked", true );
                $(elem).closest(".row").show();
            });
        }

        function multiSelectUndo(category) {
            container = "#"+category+"-list";
            select = "#"+category+"-select";

            // Ignore current state
            m_select_states[category].pop();

            // Get previous state and apply
            selVal = m_select_states[category].pop();
            $(select).val(selVal);
            manageMultiSelectForTable(category);
            $(select).trigger("focus");

            // Disable undo button if appropriate
            if (m_select_states[category][0].length <= 0 ) {
                m_select_states[category] = [];
                $("#"+category+"-undo").prop( "disabled", true );
            }
        }
    });
</script>

        <h5 class="ul"><?= _('Oracle Tablespace Metrics') ?></h5>
    <p><?= _('Specify the metrics you would like to monitor on the Oracle Tablespace') ?></p>

    <div class="row">
        <div class="col-sm-3">
            <div class="multi-select-label"><?= _('Make your Selections')?><?= xi6_info_tooltip(_("Click with shift or CRTL/CMD key to adjust your selection.")) ?></div>
            <?= $service_select_html ?>
            <div class="select-undo-wrap">
                <button type="button"  id="services-undo" class="select-undo"><i class="material-symbols-outlined md-button md-20 md-400">undo</i></button>
            </div>
        </div>
        <div class="col-sm-9">
            <div class="row">
                <div class="col-sm-10">
                    <div class="multi-select-label"><?= _('Selected Metrics')?></div>
                </div>
            </div>

            <div id="services-list" class="select-table-wrap">

        <?php

        foreach ($services_array as $name => $service) {
            $monitor = isset($services[$service]) && $services[$service] != '';
            $safe_name = $service;
            $service_tooltip = _($service_tooltips[$service]);

            ?>
            <div class="row">
                <div class="col-sm-12">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-4 mt-0 pt-1">
                            <input type="checkbox" id="services[<?= $service ?>]" class="form-check-input service-item services-<?= $safe_name ?>" name="services[<?= $service ?>]"  <?= is_checked($monitor, 'on') ?>>
                            <label for="services[<?= $service ?>]" class="form-check-label bold"><?= $name ?> <?= xi6_info_tooltip($service_tooltip) ?></label>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                </span>
                                <input type="text" id="serviceargs[<?= $service ?>_warning]" name="serviceargs[<?= $service ?>_warning]" value="<?= encode_form_val($serviceargs[$service . '_warning']) ?>" class="form-control form-control-sm monitor">
                                <span class="input-group-text">/sec</span>
                                <i id="serviceargs_<?= $service ?>_warning_Alert-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                </span>
                                <input type="text" id="serviceargs[<?= $service ?>_critical]" name="serviceargs[<?= $service ?>_critical]" value="<?= encode_form_val($serviceargs[$service . '_critical']) ?>" class="form-control form-control-sm monitor">
                                <span class="input-group-text">/sec</span>
                                <i id="serviceargs_<?= $service ?>_critical_Alert-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-1 mt-0">
                            <div class="input-group input-group-sm">
                                <button type="button" class="btn-close multi-select-remove" value="services-<?= $safe_name ?>" aria-label="Remove"></button>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>

            <?php
            }
            ?>
            </div> <!-- services-list -->
        </div>
    </div>

</div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
